"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumeRequestT = exports.ConsumeRequest = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const consumer_layers_1 = require("../../fbs/consumer/consumer-layers");
const media_kind_1 = require("../../fbs/rtp-parameters/media-kind");
const rtp_encoding_parameters_1 = require("../../fbs/rtp-parameters/rtp-encoding-parameters");
const rtp_parameters_1 = require("../../fbs/rtp-parameters/rtp-parameters");
const type_1 = require("../../fbs/rtp-parameters/type");
class ConsumeRequest {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsConsumeRequest(bb, obj) {
        return (obj || new ConsumeRequest()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsConsumeRequest(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new ConsumeRequest()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    consumerId(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    producerId(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    kind() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : media_kind_1.MediaKind.AUDIO;
    }
    rtpParameters(obj) {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? (obj || new rtp_parameters_1.RtpParameters()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    type() {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : type_1.Type.SIMPLE;
    }
    consumableRtpEncodings(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? (obj || new rtp_encoding_parameters_1.RtpEncodingParameters()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    consumableRtpEncodingsLength() {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    paused() {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    preferredLayers(obj) {
        const offset = this.bb.__offset(this.bb_pos, 18);
        return offset ? (obj || new consumer_layers_1.ConsumerLayers()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    ignoreDtx() {
        const offset = this.bb.__offset(this.bb_pos, 20);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    static startConsumeRequest(builder) {
        builder.startObject(9);
    }
    static addConsumerId(builder, consumerIdOffset) {
        builder.addFieldOffset(0, consumerIdOffset, 0);
    }
    static addProducerId(builder, producerIdOffset) {
        builder.addFieldOffset(1, producerIdOffset, 0);
    }
    static addKind(builder, kind) {
        builder.addFieldInt8(2, kind, media_kind_1.MediaKind.AUDIO);
    }
    static addRtpParameters(builder, rtpParametersOffset) {
        builder.addFieldOffset(3, rtpParametersOffset, 0);
    }
    static addType(builder, type) {
        builder.addFieldInt8(4, type, type_1.Type.SIMPLE);
    }
    static addConsumableRtpEncodings(builder, consumableRtpEncodingsOffset) {
        builder.addFieldOffset(5, consumableRtpEncodingsOffset, 0);
    }
    static createConsumableRtpEncodingsVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startConsumableRtpEncodingsVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static addPaused(builder, paused) {
        builder.addFieldInt8(6, +paused, +false);
    }
    static addPreferredLayers(builder, preferredLayersOffset) {
        builder.addFieldOffset(7, preferredLayersOffset, 0);
    }
    static addIgnoreDtx(builder, ignoreDtx) {
        builder.addFieldInt8(8, +ignoreDtx, +false);
    }
    static endConsumeRequest(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 4); // consumer_id
        builder.requiredField(offset, 6); // producer_id
        builder.requiredField(offset, 10); // rtp_parameters
        builder.requiredField(offset, 14); // consumable_rtp_encodings
        return offset;
    }
    unpack() {
        return new ConsumeRequestT(this.consumerId(), this.producerId(), this.kind(), (this.rtpParameters() !== null ? this.rtpParameters().unpack() : null), this.type(), this.bb.createObjList(this.consumableRtpEncodings.bind(this), this.consumableRtpEncodingsLength()), this.paused(), (this.preferredLayers() !== null ? this.preferredLayers().unpack() : null), this.ignoreDtx());
    }
    unpackTo(_o) {
        _o.consumerId = this.consumerId();
        _o.producerId = this.producerId();
        _o.kind = this.kind();
        _o.rtpParameters = (this.rtpParameters() !== null ? this.rtpParameters().unpack() : null);
        _o.type = this.type();
        _o.consumableRtpEncodings = this.bb.createObjList(this.consumableRtpEncodings.bind(this), this.consumableRtpEncodingsLength());
        _o.paused = this.paused();
        _o.preferredLayers = (this.preferredLayers() !== null ? this.preferredLayers().unpack() : null);
        _o.ignoreDtx = this.ignoreDtx();
    }
}
exports.ConsumeRequest = ConsumeRequest;
class ConsumeRequestT {
    consumerId;
    producerId;
    kind;
    rtpParameters;
    type;
    consumableRtpEncodings;
    paused;
    preferredLayers;
    ignoreDtx;
    constructor(consumerId = null, producerId = null, kind = media_kind_1.MediaKind.AUDIO, rtpParameters = null, type = type_1.Type.SIMPLE, consumableRtpEncodings = [], paused = false, preferredLayers = null, ignoreDtx = false) {
        this.consumerId = consumerId;
        this.producerId = producerId;
        this.kind = kind;
        this.rtpParameters = rtpParameters;
        this.type = type;
        this.consumableRtpEncodings = consumableRtpEncodings;
        this.paused = paused;
        this.preferredLayers = preferredLayers;
        this.ignoreDtx = ignoreDtx;
    }
    pack(builder) {
        const consumerId = (this.consumerId !== null ? builder.createString(this.consumerId) : 0);
        const producerId = (this.producerId !== null ? builder.createString(this.producerId) : 0);
        const rtpParameters = (this.rtpParameters !== null ? this.rtpParameters.pack(builder) : 0);
        const consumableRtpEncodings = ConsumeRequest.createConsumableRtpEncodingsVector(builder, builder.createObjectOffsetList(this.consumableRtpEncodings));
        const preferredLayers = (this.preferredLayers !== null ? this.preferredLayers.pack(builder) : 0);
        ConsumeRequest.startConsumeRequest(builder);
        ConsumeRequest.addConsumerId(builder, consumerId);
        ConsumeRequest.addProducerId(builder, producerId);
        ConsumeRequest.addKind(builder, this.kind);
        ConsumeRequest.addRtpParameters(builder, rtpParameters);
        ConsumeRequest.addType(builder, this.type);
        ConsumeRequest.addConsumableRtpEncodings(builder, consumableRtpEncodings);
        ConsumeRequest.addPaused(builder, this.paused);
        ConsumeRequest.addPreferredLayers(builder, preferredLayers);
        ConsumeRequest.addIgnoreDtx(builder, this.ignoreDtx);
        return ConsumeRequest.endConsumeRequest(builder);
    }
}
exports.ConsumeRequestT = ConsumeRequestT;
